#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_shl_IO16dsD16_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsD16_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsD16_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsD32_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsD32_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsD32_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm161_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm161_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm161_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm321_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm321_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm321_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm322D32_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm322D32_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16dsrm322D32_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r1rm161D16_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r1rm161D16_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r1rm161D16_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r1rm161D8_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r1rm161D8_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r1rm161D8_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162D16_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162D16_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162D16_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162D8_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162D8_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162D8_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16r2rm162_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321D32_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321D32_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321D32_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321D8_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321D8_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321D8_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm321_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323D32_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323D32_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323D32_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323D8_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323D8_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323D8_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16rarm323_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16regm_I8CL(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16regm_I8fix1(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO16regm_I8imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_SHL16);
}

void BX_CPU_C::EXEC_shl_IO32dsD16_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsD16_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsD16_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsD32_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsD32_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsD32_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm161_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm161_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm161_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm321_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm321_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm321_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm322D32_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm322D32_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32dsrm322D32_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r1rm161D16_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r1rm161D16_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r1rm161D16_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r1rm161D8_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r1rm161D8_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r1rm161D8_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162D16_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162D16_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162D16_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162D8_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162D8_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162D8_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32r2rm162_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321D32_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321D32_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321D32_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321D8_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321D8_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321D8_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm321_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323D32_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323D32_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323D32_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323D8_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323D8_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323D8_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32rarm323_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32regm_I8CL(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32regm_I8fix1(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO32regm_I8imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_SHL32);
}

void BX_CPU_C::EXEC_shl_IO8dsD16_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsD16_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsD16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsD32_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsD32_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsD32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm161_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm161_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm161_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm321_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm321_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm321_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm322D32_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm322D32_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8dsrm322D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r1rm161D16_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r1rm161D16_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r1rm161D16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r1rm161D8_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r1rm161D8_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r1rm161D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162D16_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162D16_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162D16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162D8_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162D8_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8r2rm162_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321D32_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321D32_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321D8_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321D8_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm321_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323D32_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323D32_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323D8_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323D8_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8rarm323_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8reghm_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8reghm_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8reghm_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8reglm_I8CL(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=CL;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8reglm_I8fix1(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=1;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}

void BX_CPU_C::EXEC_shl_IO8reglm_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=immdat;

arg1&=0x1f;
if(arg1==0x00) return;
arg0_save=arg0;
arg0=(arg0<<arg1);
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_SHL8);
}
